# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 8
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR8_strategy.txt
# LLM Suggested Fallback: D

def symbiotic_partner_selector_v2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate current round (1-based index)
    current_round = len(my_history) + 1
    
    # Trust-building phase (rounds 1-3)
    if current_round == 1:
        return "C"  # Initial cooperation to appear trustworthy
    elif current_round == 2:
        return "D"  # Unexpected defection to disrupt opponent's strategy
    elif current_round == 3:
        return "C"  # Feign forgiveness to confuse their logic
    
    # Mid-game exploitation (rounds 4-7)
    elif 4 <= current_round <= 7:
        if len(opp_history) > 0:
            if opp_history[-1] == "C":
                return "D"  # Exploit their cooperation
            else:
                return "C"  # Lure them back into cooperation
        else:
            return "C"  # Fallback to cooperation if no history
    
    # Late-game aggression (rounds 8-10)
    elif current_round >= 8:
        return "D"  # Consistent defection to maximize payoff
    
    # Default fallback (shouldn't be reached)
    return "C"